/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Block0;
import com.quantumdata.edideditor.CEAExtension;
import com.quantumdata.edideditor.EdidEditor;
import com.quantumdata.edideditor.ExtensionBlock;
import com.quantumdata.edideditor.ExtensionMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JOptionPane;

public class Edid {
    private Block0 block_0;
    private ExtensionMap block_map;
    private ExtensionBlock block_first_extension;
    private ExtensionBlock block_second_extension;
    private static final String block0String = "00FFFFFFFFFFFF0044890100010000001B10010380502D780A0DC9A05747982712484C20000001010101010101010101010101010101011D8018711C1620582C2500C48E2100009E8C0AD08A20E02D10103E9600138E21000018000000FC00446973706C61790A2020202020000000FD003B3D0F2E08000A20202020202001C1";
    private static final String block1String = "020304F100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006";

    public void updateEDIDChecksum() {
        if (this.block_0 != null) {
            this.block_0.generateChecksum();
        }
        if (this.block_map != null) {
            this.block_map.generateChecksum();
        }
        if (this.block_first_extension != null) {
            this.block_first_extension.generateChecksum();
        }
        if (this.block_second_extension != null) {
            this.block_second_extension.generateChecksum();
        }
    }

    public int getNumberBlocks() {
        int n = 0;
        if (this.block_0 != null) {
            ++n;
        }
        if (this.block_map != null) {
            ++n;
        }
        if (this.block_first_extension != null) {
            ++n;
        }
        if (this.block_second_extension != null) {
            ++n;
        }
        return n;
    }

    public boolean addBlock0(Block0 block0) {
        boolean bl = true;
        if (block0 != null) {
            if (this.block_0 == null) {
                this.block_0 = block0;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public Block0 getBlock0() {
        if (this.block_0 == null) {
            this.block_0 = new Block0();
        }
        return this.block_0;
    }

    public boolean addExtensionBlock(ExtensionBlock extensionBlock) {
        boolean bl = false;
        if (extensionBlock != null) {
            if (this.block_first_extension == null) {
                this.block_first_extension = extensionBlock;
                this.block_0.setExtensionFlag(1);
            } else if (this.block_second_extension == null) {
                this.block_map = new ExtensionMap();
                this.block_second_extension = extensionBlock;
                ((CEAExtension)this.block_second_extension).setByte3(((CEAExtension)this.block_first_extension).getByte3());
                this.block_0.setExtensionFlag(3);
                this.block_map.setExtensionBlockTag(2, this.block_first_extension.iExtensionTag);
                this.block_map.setExtensionBlockTag(3, this.block_second_extension.iExtensionTag);
                bl = true;
            }
        } else {
            bl = false;
        }
        this.block_0.generateChecksum();
        return bl;
    }

    public ExtensionBlock getExtensionBlock(int n) {
        ExtensionBlock extensionBlock = n == 1 ? this.block_first_extension : (n == 2 ? this.block_second_extension : null);
        return extensionBlock;
    }

    public boolean removeExtensionBlock(int n) {
        boolean bl = false;
        if (n == 1) {
            if (this.block_first_extension == null) {
                bl = false;
            } else if (this.block_second_extension != null) {
                this.block_first_extension = this.block_second_extension;
                this.block_second_extension = null;
                this.block_map = null;
                this.block_0.setExtensionFlag(1);
                bl = true;
            } else {
                this.block_first_extension = null;
                this.block_map = null;
                this.block_0.setExtensionFlag(0);
                bl = true;
            }
        } else if (n == 2) {
            if (this.block_second_extension == null) {
                bl = false;
            } else {
                this.block_second_extension = null;
                this.block_map = null;
                this.block_0.setExtensionFlag(1);
                bl = true;
            }
        }
        this.block_0.generateChecksum();
        return bl;
    }

    public String swapExtensionBlocks(int n, int n2) {
        String string = null;
        if (n < 2 | n2 < 2 | n > 3 | n2 > 3) {
            string = "ERROR: Index is out of bounds";
        }
        if (n2 == 3) {
            ExtensionBlock extensionBlock = this.block_second_extension;
            this.block_second_extension = this.block_first_extension;
            this.block_first_extension = extensionBlock;
            this.block_map.swapBlockPositions(2, 3);
        } else {
            ExtensionBlock extensionBlock = this.block_first_extension;
            this.block_first_extension = this.block_second_extension;
            this.block_second_extension = extensionBlock;
            this.block_map.swapBlockPositions(3, 2);
        }
        return string;
    }

    public ExtensionMap getExtensionMap() {
        ExtensionMap extensionMap = this.block_map == null ? null : this.block_map;
        return extensionMap;
    }

    private boolean addExtensionMap(ExtensionMap extensionMap) {
        boolean bl = true;
        if (this.block_map == null) {
            this.block_map = extensionMap;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean removeExtensionMap() {
        if (this.block_map == null) {
            return false;
        }
        this.block_map = null;
        return true;
    }

    public String buildTextEDID() {
        StringBuffer stringBuffer = new StringBuffer(this.block_0.extractBlockData());
        if (this.block_map != null) {
            stringBuffer.append(this.block_map.extractBlockData());
        }
        if (this.block_first_extension != null) {
            stringBuffer.append(this.block_first_extension.extractBlockData());
        }
        if (this.block_second_extension != null) {
            stringBuffer.append(this.block_second_extension.extractBlockData());
        }
        return stringBuffer.toString();
    }

    public Object buildEDID(File file) {
        String string = new String(this.block_0.extractBlockData());
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<DATAOBJ>");
            printWriter.println("<HEADER TYPE=\"DID\" VERSION=\"1.0\"></HEADER>");
            printWriter.println("<DATA>");
            printWriter.print("<BLOCK0>");
            printWriter.print(string);
            printWriter.println("</BLOCK0>");
            printWriter.print("<BLOCK1>");
            if (this.block_map != null) {
                printWriter.print(this.block_map.extractBlockData());
            } else if (this.block_first_extension != null) {
                printWriter.print(this.block_first_extension.extractBlockData());
            }
            printWriter.println("</BLOCK1>");
            printWriter.print("<BLOCK2>");
            if (this.block_map != null && this.block_first_extension != null) {
                printWriter.print(this.block_first_extension.extractBlockData());
            }
            printWriter.println("</BLOCK2>");
            printWriter.print("<BLOCK3>");
            if (this.block_map != null & this.block_second_extension != null) {
                printWriter.print(this.block_second_extension.extractBlockData());
            }
            printWriter.println("</BLOCK3>");
            printWriter.println("</DATA>");
            printWriter.println("</DATAOBJ>");
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(EdidEditor.theApp, iOException.getMessage());
            return 0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseEDID(BufferedReader bufferedReader) {
        String string = null;
        try {
            Object object;
            int n;
            if (bufferedReader == null) {
                return "ERROR: XML input is null";
            }
            int n2 = 0;
            int n3 = 0;
            for (n2 = 0; n2 <= 3; ++n2) {
                bufferedReader.readLine();
            }
            String string2 = new String(bufferedReader.readLine());
            int n4 = string2.indexOf(60, n = string2.indexOf(62));
            int n5 = n4 - n;
            if (n5 < 1) {
                return "ERROR: Please check format of XML file.";
            }
            Block0 block0 = new Block0();
            string = block0.uploadData(string2 = new String(string2.substring(n + 1, n4)));
            if (string != null) {
                return string;
            }
            this.addBlock0(block0);
            n3 = Integer.parseInt(block0.getExtensionFlag(), 10);
            string2 = new String(bufferedReader.readLine());
            n = string2.indexOf(62);
            n4 = string2.indexOf(60, n);
            n5 = n4 - n;
            if (n5 <= 1) return string;
            int n6 = Integer.parseInt((string2 = new String(string2.substring(n + 1, n4))).substring(0, 2), 16);
            if (n6 == 240) {
                if (n3 == 0) {
                    return "ERROR: No extension blocks expected, so\n  No map block expected.  One block EDID seen.";
                }
                if (n3 == 1) {
                    return "ERROR: Only one extension block\n Map block seen but not expected.  This shouldbe extension data";
                }
                object = new ExtensionMap();
                ((ExtensionMap)object).uploadData(string2);
                this.addExtensionMap((ExtensionMap)object);
            } else {
                if (n3 == 0) {
                    return "ERROR: No extension blocks expected, so\n  No map block expected but a map block was seen.  This is an invalid one block EDID.";
                }
                if (n3 >= 2) {
                    return "ERROR: At least two extension blocks are expected with this \n  EDID but this EDID does not contain a map block.";
                }
                object = new CEAExtension();
                ((ExtensionBlock)object).uploadData(string2);
                this.addExtensionBlock((ExtensionBlock)object);
            }
            string2 = new String(bufferedReader.readLine());
            n = string2.indexOf(62);
            n4 = string2.indexOf(60, n);
            n5 = n4 - n;
            if (n5 > 1) {
                if (n3 <= 1) {
                    string = "Error...Not expecting extension block data here";
                }
                if ((n6 = Integer.parseInt((string2 = new String(string2.substring(n + 1, n4))).substring(0, 2), 16)) == 2) {
                    object = new CEAExtension();
                    ((CEAExtension)object).uploadData(string2);
                    this.addExtensionBlock((ExtensionBlock)object);
                } else {
                    string = new String("Extension block tag ");
                    string = string.concat(String.format("%02X", n6));
                    string = string.concat(" is not supported at this time.");
                }
            } else if (n3 - 1 == 2) {
                string = "Error...Block 0 says that there are two extension blocks in this EDID.  Did not find the second extension block\n";
            }
            string2 = new String(bufferedReader.readLine());
            n = string2.indexOf(62);
            n4 = string2.indexOf(60, n);
            n5 = n4 - n;
            if (n5 > 1) {
                if (n3 != 3) {
                    string = "Error...Not expecting extension block data here";
                }
                if ((n6 = Integer.parseInt((string2 = new String(string2.substring(n + 1, n4))).substring(0, 2), 16)) != 2) {
                    string = new String("Extension block tag ");
                    string = string.concat(String.format("%02X", n6));
                    return string.concat(" is not supported at this time.");
                }
                object = new CEAExtension();
                ((CEAExtension)object).uploadData(string2);
                this.addExtensionBlock((ExtensionBlock)object);
            } else if (n3 - 1 == 2) {
                string = "Error...Block 0 says that there are twoextension blocks in this EDID.  Did not find the second one\n";
            }
            bufferedReader.close();
            return string;
        }
        catch (IOException iOException) {
            return "error message: " + iOException.getMessage();
        }
    }

    public String loadDefaultEdid() {
        String string = null;
        String string2 = null;
        Block0 block0 = null;
        CEAExtension cEAExtension = null;
        block0 = new Block0();
        string = new String(block0String);
        string2 = block0.uploadData(string);
        if (string2 != null) {
            return string2;
        }
        this.addBlock0(block0);
        string = new String(block1String);
        cEAExtension = new CEAExtension();
        string2 = cEAExtension.uploadData(string);
        if (string2 != null) {
            return string2;
        }
        this.addExtensionBlock(cEAExtension);
        return string2;
    }
}

